**free
// RPG BATTLE DEV 2025 - Manche 3 - Epreuve 1A - Du 5 au 7 novembre 2025
//
// Cette épreuve est composée de 2 parties (A et B), avec 2 membres source (E5A et E5B) :
//  Partie A (source E5A) : création d'une procédure ILE, encapsulation dans un programme de service
//  Partie B (source E5B) : appel de la procédure créée à la partie A
//
// Partie A - Source E5A

// Objectif : coder une procédure statutFilm qui prendra les caractéristiques suivantes :
//
// 1. Réception de 3 paramètres :
//   - TITRE de type VARCHAR(100)
//   - ETAT de type VARCHAR(10)
//   - DATESORTIE de type VARCHAR(20)
//
// 2. Lorsque l'on appellera la procédure dans la partie B et que l'on ne passera pas de valeur pour le paramètre DATESORTIE  alors
//    la valeur 'inconnue' lui sera affecté
//
// 3. Lorsque l'on appellera la procédure dans la partie B, on pourra passer les codes suivants pour le paramètres ETAT :
//      - 'C00' qui signifie CONCEPTION
//      - 'P00' qui signifie PREPARATION
//      - 'T00' qui signifie TOURNAGE
//      - 'P10' qui signifie POSTPRODUCTION
//      - 'D00' qui signifie DIFFUSION
//
// 4. L'information "Etat du tournage" pourra prendre les valeurs suivantes :
//   - 'Tournage non démarré' si ETAT vaut C00 ou P00
//   - 'Tournage en cours' si ETAT vaut T00
//   - 'Tournage terminé' si ETAT vaut P10 ou D00
//   - 'Etat du tournage inconnu' si l'on passe la valeur nulle pour le paramètre ETAT
//
// 5. La procédure renverra la chaîne suivante : TITRE suivi de "Etat du tournage" suivi de DATESORTIE :
//      - Par exemple pour le film "DUNE 3", qui est actuellement en "TOURNAGE" et qui sortira le "16/12/2026", la procédure renverra
//          DUNE 3 - Tournage en cours - Date de sortie : 16/12/2026
//      - Autre exemple de sortie : STAR WARS: DAWN OF THE JEDI - Tournage non démarré - Date de sortie : inconnue
//      - Vous trouverez d'autres cas de figure dans l'énoncé de l'exercice E5B
//
// 6. La procédure devra être encapsulée dans un programme de service intitulé E5A et devra avoir la signature suivante : RPG_BATTLE_DEV_2025


// Consignes :
//  1. Ne pas modifier les lignes de code déjà présentes, ajouter vos lignes de code nécessaires
//  2. Utiliser uniquement des instructions RPG natives (pas de SQL, pas d'appels d'API...)
//  3. Vous pouvez créer tous les sources et objets dont vous avez besoin dans votre bibliothèque

// Critères d'évaluation :
//  1. Le résultat doit être celui demandé
//  2. Le code présent ne doit pas être modifié
//  3. Le code doit être le plus simple, le plus lisible possible et le plus optimisé
//  4. Le programme doit s'appeler E5A dans votre bibliothèque TEAMXX

// -----------------------------------------------------------------------------
// Votre profil IBM i : TEAMXX
// -----------------------------------------------------------------------------

ctl-opt nomain alwnull(*usrctl);

dcl-proc statutFilm export;

  dcl-pi *n varchar(200);
    titre      varchar(100) options(*trim) const;            // Pour suppression des espaces
    etat       varchar(10)  options(*nullind) const;         // Pour passage de la valeur nulle
    dateSortie varchar(20)  options(*nopass:*convert) value; // Pour passage optionnel et transformation en alphanumérique
  end-pi;

  dcl-s etatTournage varchar(50);

  dcl-enum etatFilm;
    conception 'C00';
    preparation 'P00';
    tournage 'T00';
    postproduction 'P10';
    diffusion 'D00';
  end-enum;

  if not %passed(dateSortie);
    dateSortie = 'inconnue';
  endif;

  select;
    when %nullind(etat);
      etatTournage = 'Etat du tournage inconnu';
    when %trim(etat) in %list(conception:preparation);
       etatTournage = 'Tournage non démarré';
    when %trim(etat) = tournage;
      etatTournage = 'Tournage en cours';
    when %trim(etat) in %list(postproduction:diffusion);
      etatTournage = 'Tournage terminé';
  endsl;

  // Autre solution :
  //  if %nullind(etat);
  //    etatTournage = 'Etat du tournage inconnu';
  //  endif;
  //
  //  select %trim(etat);
  //    when-in %list(conception:preparation);
  //      etatTournage = 'Tournage non démarré';
  //    when-is tournage;
  //      etatTournage = 'Tournage en cours';
  //    when-in %list(postproduction:diffusion);
  //      etatTournage = 'Tournage terminé';
  //  endsl;

  return %concat(' - ' : titre : etatTournage : 'Date de sortie : ' + dateSortie);

end-proc;
