**FREE
ctl-opt actgrp(*new) openopt(*nocvtdata);

dcl-f meftxtf00 extdesc('TEAMLIB/MEFTXTF00') extfile(*extdesc) alias;

dcl-s text_modifie     varchar(1000);
dcl-s ligne_texte      varchar(100);
dcl-s lettre           char(1);
dcl-s ponctuation      char(1);
dcl-s ligne_separation char(20) inz(*all'-');
dcl-c separateur '|';

dcl-ds *n;
   alphabet            char(26) inz('ABCDEFGHIJKLMNOPQRSTUVWXYZ');
   alphabetLettre      char(1)  dim(26) overlay(alphabet);
end-ds;

// Lecture du texte à formater
read meftxtf00;
if %error or %eof(meftxtf00);
   return;
endif;

// Remplacement des doubles espaces par une ligne de tirets
text_modifie = %scanrpl('  '
                       :separateur + ligne_separation + separateur
                       :%trim(TEXTE_BRUT));

// Ajout des séparateurs de lignes
// pour chaque majuscule précédée de '. ' ou ', '
for-each lettre in alphabetLettre;
   for-each ponctuation in %list('.' :',');
      text_modifie = %scanrpl(ponctuation + ' ' + lettre
                             :ponctuation + separateur + lettre
                             :text_modifie);
   endfor;
endfor;

// Correction '!' à remplacer par 'V'
text_modifie = %scanrpl('!' :'V' :text_modifie);

// Envoi en joblog chaque ligne de texte (découpage à chaque separateur)
for-each ligne_texte in %split(text_modifie :separateur);
   snd-msg ligne_texte;
endfor;

*inlr = *on;

